var calendars = new Array();
var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove(event)
{
	if(!flipShown)
	{
		if(animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
				
		var starttime = (new Date).getTime() - 13;
				
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
}

function mouseexit(event)
{
	if (flipShown)
	{
		// fade in the info button
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
				
		var starttime = (new Date).getTime() - 13;
				
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	T = limit_3(time-animation.starttime, 0, animation.duration);
		
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
		
	animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c)
{
	return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
	return from + (to - from) * ease;
}

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function preferenceForKey(key)
{
	var value = widget.preferenceForKey(createKey(key));
	var value;
	
	if(value == null) { // Use defaults
		if(key == "calendarKey") { // backwards compatibility
			value = iCalEventsPlugin.calendarValueForProperty("Key", 0);
		} else if(key == "calendarKeys") {
			value = iCalEventsPlugin.defaultSelectedCalendars(); // unserialized below
		} else if(key == "dateRange") {
			value = 1;
		}
	}
	
	if(value == null)
		value = "";

	if(key == "calendarKeys") {
		if(value == "")
			value = new Array();
		else
			value = unserializeArray(value);
	}
	//alert(key + " : " + value);
	return value;
}

function setPreferenceForKey(value, key)
{
	// Serialize if necessary
	if(value != null && key == "calendarKeys") {
		value = serializeArray(value);
	}
	
	widget.setPreferenceForKey(value, createKey(key));
}

function savePreferences()
{
	setPreferenceForKey(calendarKeys, "calendarKeys");
	
	// Date range
	var select = document.getElementById("dateRangePopup");
	dateRange = select.options[select.selectedIndex].value, "dateRange";
	setPreferenceForKey(dateRange, "dateRange");
}

function hidePrefs()
{
	savePreferences();

	setTimeout('updateData();', 0); // execute in background
	// Scroll to top of paper
	scrollContent(SCROLLBAR_TOP);

	var front = document.getElementById("front");
	var back = document.getElementById("back");
		
	if (window.widget)
		widget.prepareForTransition("ToFront");
				
	back.style.display = "none";
	front.style.display = "block";
   
	if (window.widget)
		setTimeout('widget.performTransition();', 0);
	
}

// Removes all occurrences of object from array
function removeOccurrencesFromArray(arr, obj) {
	var newArr = new Array();
	//alert("removeOccurrencesFromArray({" + arr + "}, " + obj + ") [arr.length = " + arr.length + "]");
	
	for(var i = 0; i < arr.length; i++) {
		if(arr[i] != obj)
			newArr.push(arr[i]);
	}
	return newArr;
}

function checkCheckbox(uid) {
	document.getElementById("check" + uid).style.background = "url(Images/chkbx/check.png) no-repeat top left";
	document.getElementById("hidden" + uid).value = "1";
}

function uncheckCheckbox(uid) {
	document.getElementById("check" + uid).style.background = "none";
	document.getElementById("hidden" + uid).value = "0";
}

function toggleCheckbox(uid) {
	var hiddenInput = document.getElementById("hidden" + uid); 
	
	if(hiddenInput.value == "1") {
		uncheckCheckbox(uid);
		calendarKeys = removeOccurrencesFromArray(calendarKeys, uid);
	} else {
		checkCheckbox(uid);
		calendarKeys.push(uid);
	}
}

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
		
	if (window.widget)
		widget.prepareForTransition("ToBack");
				
	front.style.display = "none";
	back.style.display = "block";
		
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
	
	// Reload calendar list and fill in scrolling div with available calendars
	// attributes
	iCalEventsPlugin.loadCalendars();
	
	var numCalendars = iCalEventsPlugin.numCalendars();
	var calendarBox = document.getElementById('calendarBox');
	var element;

	calendarBox.innerHTML = "<table>";
	for(var i = 0; i < numCalendars; i++) {
		calendarKey = iCalEventsPlugin.calendarValueForProperty("Key", i);

		calendarBox.innerHTML += "<tr><td><div class=\"chkbxWrapper\" id=\"chkbx" + calendarKey + "\">" +
			"<div class=\"chkbxShadow\"><div class=\"chkbx\" onclick=\"" +
				"toggleCheckbox('" + calendarKey + "');\">" +
				"<div class=\"check\" id=\"check" + calendarKey + "\">" +
			"</div></div></div></div></td>" +
		//iCalEventsPlugin.calendarValueForProperty("Key", i) + "\">" +
		"<td><div class=\"calendarName\" onclick=\"toggleCheckbox('" + calendarKey + "');\">" + truncateString(iCalEventsPlugin.calendarValueForProperty("Title", i), MAX_CALENDAR_NAME_LENGTH) + "</div></td></tr>" +
		// hidden form variable for checkbox value
		"<input type=\"hidden\" id=\"hidden" + calendarKey + "\" value=\"0\" />";
		
		// Set checkbox color; last two characters are unneeded (always FF)
		document.getElementById("chkbx" + calendarKey).style.background = iCalEventsPlugin.calendarValueForProperty("ThemeColor", i).substring(0,7) + " url(Images/chkbx/shape.png) no-repeat top left";
		
		//alert("color = " + iCalEventsPlugin.calendarValueForProperty("ThemeColor", i).substring(0,7));
	}
	
	//alert("HTML:\n" + calendarBox.innerHTML);
	
	// Fill in existing values for checkboxes
	
	// Reload calendar keys in case they've changed
	//alert("// Reload calendar keys in case they've changed");
	calendarKeys = preferenceForKey("calendarKeys");
	
	for(var i = 0; i < calendarKeys.length; i++) {
		 // Only update the visual, because calendarKeys already contains these values
		checkCheckbox(calendarKeys[i]);
	}

	// Fill in dateRangePopup
	var dateRangePopup = document.getElementById('dateRangePopup');
	dateRangePopup.innerHTML = "";
	// The first one is a special case
	element = document.createElement("option");
	element.innerText = getLocalizedString("1 day");
	element.value = "1"; // value is amount to add to month date
	dateRangePopup.appendChild(element);

	for(var i = 2; i <= 14; i++) { // first week given in days
		element = document.createElement ("option");
		element.innerText = getLocalizedString("%i days").replace("%i", i);
		element.value = i;
		if(element.value == dateRange)
			element.selected = "selected";
		dateRangePopup.appendChild(element);
	}
	
	// Weeks -- a bit slow at the moment
	/*
	for(var i = 1; i <= 4; i++) {
		element = document.createElement ("option");
		if(i == 1) {
			element.innerText = getLocalizedString("The end of the day, 1 week from now");
		} else {
			element.innerText = getLocalizedString("The end of the day, %i weeks from now").replace("%i", i);
		}
		element.value = i * 7;
		if(element.value == dateRange)
			element.selected = "selected";
		dateRangePopup.appendChild(element);
	}
	*/

	// Done button
	document.getElementById('done').innerHTML = "";
	createGenericButton(document.getElementById('done'), getLocalizedString('Done'), hidePrefs);
}

function changeDateRange(select)
{
	scrollContent(-1); // scroll to top, since content changed
}
